# 선형 탐색

## 문제

n개 원소로 구성된 배열이 주어졌을 때, 특정 원소의 인덱스를 찾는 함수를 구하라.

## 절차

1. 배열의 첫 원소와 찾고자 하는 원소를 비교한다.
2. 만약 같다면 그 인덱스를 반환한다.
   - 만약 다르다면, 다음 원소와 찾고자 하는 원소를 비교한다.
3. 만약 찾고자 하는 원소가 없다면 -1을 반환한다.

## 시간 복잡도

- 최악의 경우: $O(n)$
- 최선의 경우: $O(1)$ (배열의 첫번째 원소가 찾는 원소인 경우)

## 공간 복잡도

- $O(1)$

## 예시

```
arr = [1, 3, 9, 5, 0, 2]
target = 5

1과 5가 같지 않으므로 다음 원소와 목표를 비교한다.
3과 5가 같지 않으므로 다음 원소와 목표를 비교한다.
9과 5가 같지 않으므로 다음 원소와 목표를 비교한다.
5가 4번째 위치에 있으므로 3을 반환한다.
```

```
arr = [1, 3, 9, 5, 0, 2]
target = 6

1과 6이 같지 않으므로 다음 원소와 목표를 비교한다.
3과 6이 같지 않으므로 다음 원소와 목표를 비교한다.
9과 6이 같지 않으므로 다음 원소와 목표를 비교한다.
5와 6이 같지 않으므로 다음 원소와 목표를 비교한다.
0과 6이 같지 않으므로 다음 원소와 목표를 비교한다.
마지막 원소가 목표와 같지 않으므로 6이 배열에 들어있지 않다고 판단하여 -1을 반환한다.
```

## 구현

- [Java](https://github.com/TheAlgorithms/Java/blob/master/Searches/LinearSearch.java)
- [C++](https://github.com/TheAlgorithms/C-Plus-Plus/blob/master/Search/Linear%20Search.cpp)
- [Python](https://github.com/TheAlgorithms/Python/blob/master/searches/linear_search.py)

## 영상 URL

- [CS50](https://www.youtube.com/watch?v=CX2CYIJLwfg)

## 기타

- [Tute Board](https://boardhub.github.io/tute/?wd=linearSearchAlgo)
